import { PrismaClientService } from '../prisma-client/prisma-client.service';
import { Prisma, User } from '@prisma/client';
export declare class UserService {
    private prismaService;
    constructor(prismaService: PrismaClientService);
    create(data: Prisma.UserCreateInput): Promise<User>;
    updateUser(params: {
        where: Prisma.UserWhereUniqueInput;
        data: Prisma.UserUpdateInput;
    }): Promise<{
        name: string | null;
        id: number;
        email: string;
        password: string;
    }>;
    users(params: {
        skip?: number;
        take?: number;
        cursor?: Prisma.UserWhereUniqueInput;
        where?: Prisma.UserWhereInput;
        orderBy?: Prisma.UserOrderByWithRelationInput;
    }): Promise<User[]>;
    getUser(dto: Prisma.UserWhereUniqueInput): Promise<User | null>;
    deleteUser(where: Prisma.UserWhereUniqueInput): Promise<User>;
}
