"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalAuthGuard = void 0;
const passport_1 = require("@nestjs/passport");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const login_dto_1 = require("../dto/login.dto");
const common_1 = require("@nestjs/common");
let LocalAuthGuard = class LocalAuthGuard extends (0, passport_1.AuthGuard)('local') {
    async canActivate(context) {
        const request = context.switchToHttp().getRequest();
        const response = context.switchToHttp().getResponse();
        const body = (0, class_transformer_1.plainToInstance)(login_dto_1.LoginDto, request.body);
        const errors = await (0, class_validator_1.validate)(body);
        const errorMessages = errors.flatMap(({ constraints }) => constraints ? Object.values(constraints) : []);
        if (errorMessages.length > 0) {
            response.status(common_1.HttpStatus.BAD_REQUEST).send({
                statusCode: common_1.HttpStatus.BAD_REQUEST,
                error: 'Bad Request',
                message: errorMessages,
            });
        }
        return super.canActivate(context);
    }
};
exports.LocalAuthGuard = LocalAuthGuard;
exports.LocalAuthGuard = LocalAuthGuard = __decorate([
    (0, common_1.Injectable)()
], LocalAuthGuard);
//# sourceMappingURL=local.guard.js.map