import { AuthService } from './auth.service';
import { UserService } from '../user/user.service';
import { RegisterDto } from './dto/register.dto';
import { CustomRequest } from 'src/utils/customRequest';
export declare class AuthController {
    private readonly authService;
    private readonly userService;
    constructor(authService: AuthService, userService: UserService);
    register(body: RegisterDto): Promise<Omit<{
        name: string | null;
        id: number;
        email: string;
        password: string;
    }, "password">>;
    login(req: CustomRequest): Promise<{
        access_token: any;
        user: Omit<{
            name: string | null;
            id: number;
            email: string;
            password: string;
        }, "password">;
    }>;
}
