"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlumniService = void 0;
const common_1 = require("@nestjs/common");
const prisma_client_service_1 = require("../prisma-client/prisma-client.service");
let AlumniService = class AlumniService {
    prismaService;
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async getAll() {
        return this.prismaService.alumni.findMany();
    }
    async getSingleAlumni(alumniId) {
        return this.prismaService.alumni.findUnique({
            where: { id: +alumniId },
        });
    }
    async createAlumni(alumniData) {
        return this.prismaService.alumni.create({ data: alumniData });
    }
    async editAlumni(alumniId, alumniData) {
        const found_alumni = await this.getSingleAlumni(+alumniId);
        if (!found_alumni) {
            return new Promise((resolve, reject) => {
                resolve({ message: 'Not Found' });
            });
        }
        return this.prismaService.alumni.update({
            where: { id: +alumniId },
            data: alumniData,
        });
    }
    async deleteAlumni(alumniId) {
        const found_alumni = await this.getSingleAlumni(+alumniId);
        if (!found_alumni) {
            return new Promise((resolve, reject) => {
                resolve({ message: 'Not Found' });
            });
        }
        return this.prismaService.alumni.delete({ where: { id: +alumniId } });
    }
};
exports.AlumniService = AlumniService;
exports.AlumniService = AlumniService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [prisma_client_service_1.PrismaClientService])
], AlumniService);
//# sourceMappingURL=alumni.service.js.map