"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlumniController = void 0;
const common_1 = require("@nestjs/common");
const alumni_service_1 = require("./alumni.service");
const alumni_model_1 = require("./models/alumni.model");
const public_decorator_1 = require("../auth/decorators/public.decorator");
const jwt_guard_1 = require("../auth/guards/jwt.guard");
let AlumniController = class AlumniController {
    alumniService;
    constructor(alumniService) {
        this.alumniService = alumniService;
    }
    async getAllAlumni() {
        return this.alumniService.getAll();
    }
    async getSingleAlumni(id) {
        return this.alumniService.getSingleAlumni(+id);
    }
    async createAlumni(alumniData) {
        return this.alumniService.createAlumni(alumniData);
    }
    async editPost(id, alumniData) {
        return this.alumniService.editAlumni(+id, alumniData);
    }
    async deleteAlumni(id) {
        return this.alumniService.deleteAlumni(+id);
    }
};
exports.AlumniController = AlumniController;
__decorate([
    (0, common_1.UseGuards)(jwt_guard_1.JwtAuthGuard),
    (0, common_1.Get)('all'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AlumniController.prototype, "getAllAlumni", null);
__decorate([
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], AlumniController.prototype, "getSingleAlumni", null);
__decorate([
    (0, public_decorator_1.Public)(),
    (0, common_1.Post)('create'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [alumni_model_1.AlumniModel]),
    __metadata("design:returntype", Promise)
], AlumniController.prototype, "createAlumni", null);
__decorate([
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, alumni_model_1.AlumniModel]),
    __metadata("design:returntype", Promise)
], AlumniController.prototype, "editPost", null);
__decorate([
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], AlumniController.prototype, "deleteAlumni", null);
exports.AlumniController = AlumniController = __decorate([
    (0, common_1.Controller)('api/v1/alumni'),
    __metadata("design:paramtypes", [alumni_service_1.AlumniService])
], AlumniController);
//# sourceMappingURL=alumni.controller.js.map