"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const prisma_client_service_1 = require("./modules/prisma-client/prisma-client.service");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    const options = {
        origin: '*',
        methods: 'GET,HEAD,PUT,PATCH,POST,DELETE,OPTIONS,HEADER',
        preflightContinue: false,
        optionsSuccessStatus: 204,
        credentials: true,
    };
    app.enableCors(options);
    const prismaClient = app.get(prisma_client_service_1.PrismaClientService);
    await app.listen(process.env.PORT ?? 3000);
    prismaClient.enableShutDownHooks(app);
}
bootstrap();
//# sourceMappingURL=main.js.map